/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <jb>

#define PLUGIN "FootBall Menu"
#define VERSION "1.0"
#define AUTHOR "@pilsinka"

new owner, trail, ent, mxplr
new bool:team
new Float:delay[33]
new const ballmodel[] = { "models/ball.mdl" }
//new const snd[] = { "bounce.wav" }
public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_clcmd("say /football", "football")
	
	register_forward(FM_PlayerPreThink, "prethink")
	
	RegisterHam(Ham_Think, "info_target", "ball_think")
	RegisterHam(Ham_Touch, "info_target", "ball_touch")
	RegisterHam(Ham_Killed, "player", "die")
	register_logevent("remove_ball", 2, "0=World triggered", "1=Round_End")
	register_logevent("remove_ball", 2, "0=World triggered", "1=Round_Start")
	
	mxplr = get_maxplayers()
}

public plugin_precache()
{
	precache_model(ballmodel)
	//precache_sound(snd)
	trail = precache_model("sprites/smoke.spr")
}

public football(id)
{
	static model[64]
	get_user_info(id, "model", model, 63)
	
	if(!is_user_alive(id) || !(jb_is_user_simon(id) || (get_user_flags(id) & ADMIN_LEVEL_D)))
	return PLUGIN_HANDLED
	


	static menu
	menu = menu_create("Funny JB football", "mhand")
		
	menu_additem(menu,"Поделить на команды", "1")
		
		
	menu_additem(menu, "Поставить мяч", "2")
		
	menu_additem(menu, "Убрать мяч", "3")
		
	menu_display(id, menu)

	return PLUGIN_HANDLED
	
	
}

public mhand(id, menu, item, client)
{
	if(item == MENU_EXIT || !is_user_alive(id))
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
		
	}
	
	static data[6], name[64], acs, cllbck, key
	menu_item_getinfo(menu, item, acs, data, 5, name, 63, cllbck)
	key = str_to_num(data)
	switch(key)
	{
		case 1:
		{
   			hud_msg(0 , "Команды поделены!" , 0, 160, 0,  -1.0, 0.02, 0, 6.0, 9.0, 0.1, 1.5 )
			make_teams()
			
		}
		case 2:
		{
   			hud_msg(0 , "Мячик поставлен!" , 0, 160, 0,  -1.0, 0.02, 0, 6.0, 9.0, 0.1, 1.5 )
			ball(id)
		}
		case 3:
		{
			if(ent > 0)
			{
				hud_msg(0 , "Мячик убран!"  , 0, 160, 0,  -1.0, 0.02, 0, 6.0, 9.0, 0.1, 1.5 )
				engfunc(EngFunc_RemoveEntity, ent)
				ent = 0
				client_print(id, print_chat, "Мяч убран")
			}
			else
			{
				client_print(id, print_chat, "Его итак нету!")
			}
		}
	}
	
	menu_destroy(menu)
	return PLUGIN_HANDLED
	
}

public make_teams()
{
	static i 
	for(i = 0; i < mxplr; i++)
	{
		if(!is_user_alive(i) || get_user_team(i) != 1)
		continue
		
		if(team)
		{
			set_pev(i, pev_skin, 0)
			
		}
		else
		{
			set_pev(i, pev_skin, 2)
		}
		
		team = !team
		
	}
	
}
	
public remove_ball()
{
	set_task(0.5, "kill_ball")
	
	
}

public kill_ball()
{
	if(ent > 0)
	{
		engfunc(EngFunc_RemoveEntity, ent)
		team = !team
		owner = 0
		ent = 0
		
	}
	
}

public client_disconnect(id)
{
	if(id == owner)
		owner = 0
		
}
	
public die(id, ida, sgibs)
{
	if(id == owner)
		owner = 0
	
}

public ball(id)
{
	static Float:orig[3], Float:vel[3]
	pev(id, pev_origin, orig)
	velocity_by_aim(id, 50, vel)
	orig[0] += vel[0]
	orig[1] += vel[1]
	orig[2] += vel[2]
	if(ent > 0)
	{
		set_pev(ent, pev_origin, orig)
		engfunc(EngFunc_DropToFloor, ent)
		set_pev(ent, pev_solid, SOLID_BBOX)
		set_pev(ent, pev_movetype, MOVETYPE_BOUNCE)
		engfunc(EngFunc_SetSize, ent,Float:{-7.0, -7.0, -0.0}, Float:{7.0, 7.0, 100.0})
		owner = 0
		
	}
	else
	{
		ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
		if(pev_valid(ent))
		{
			set_pev(ent, pev_classname, "ball")
			set_pev(ent, pev_origin, orig)
			engfunc(EngFunc_SetModel, ent, ballmodel)
			set_pev(ent, pev_solid, SOLID_BBOX)
			set_pev(ent, pev_movetype, MOVETYPE_BOUNCE)
			engfunc(EngFunc_SetSize, ent,Float:{-7.0, -7.0, -0.0}, Float:{7.0, 7.0, 100.0})
			
			set_pev(ent, pev_nextthink, get_gametime() + 1.0)
			engfunc(EngFunc_DropToFloor, ent)
		}
	}
	
}
		
public prethink(id)
{
	if(!is_user_alive(id) || !pev_valid(ent))
	return FMRES_IGNORED
	
	static button
	button = pev(id, pev_button)
	if(owner == id)
	{
		static Float:orig[3], Float:vel[3]
		pev(owner, pev_origin, orig)	
		
		if(button & IN_FORWARD)
		{
			velocity_by_aim(id, 80, vel)
		}
		else
		{
			velocity_by_aim(id, 50, vel)
		}
		
		orig[0] += vel[0]
		orig[1] += vel[1]
		
		if(pev(id, pev_flags) & FL_DUCKING)
		{
			orig[2] -= 11.0
			
		}
		else
		{
			orig[2] -= 34.0
		}
		
		set_pev(ent, pev_origin, orig)
		if(pev(ent, pev_solid) != SOLID_NOT)
		{
			set_pev(ent, pev_solid, SOLID_NOT)
		}

		if((button & IN_USE)  && !(pev(id, pev_oldbuttons) & IN_USE) && (delay[id] + 0.3 <= get_gametime()))
		{
			kill_follow(ent)
			velocity_by_aim(owner, 1000, vel)
			
			set_pev(ent, pev_solid, SOLID_BBOX)
			set_pev(ent, pev_movetype, MOVETYPE_BOUNCE)
			engfunc(EngFunc_SetSize, ent,Float:{-7.0, -7.0, -0.0}, Float:{7.0, 7.0, 100.0})
			fm_set_rendering(ent, kRenderFxGlowShell, 200, 0, 0, kRenderNormal, 3)
			beam_follow(ent, 11, 10, 200, 0, 0)
			beam_follow(ent, 11, 7, 150, 150, 0 )
			set_pev(ent, pev_velocity, vel)
			owner = 0
		}
	}
	else
	{
		if((button & IN_USE) && !(pev(id, pev_oldbuttons) & IN_USE))
		{
			//client_print(id, print_chat, "Forward 1")
			if(owner > 0)
			{
				//client_print(id, print_chat,"Forward 2")
				static Float:orig1[3], Float:orig2[3], Float:dist
				pev(ent, pev_origin, orig1)
				pev(id, pev_origin, orig2)
				orig1[2] = 0.0
				orig2[2] = 0.0
				dist = vector_distance(orig1, orig2)
				//client_print(id, print_chat, "Dist: %f", dist)
				
				if(dist < 60.0)
				{
					//client_print(id, print_chat, "Forward 3")
					owner = id
					delay[id] = get_gametime()
				}
			}
		}
	}
	
	return FMRES_IGNORED
	
}

public ball_touch(ient, id)
{
	static classname[32]
	pev(ient, pev_classname, classname, 31)
	
	if(!equal(classname, "ball"))
	return HAM_IGNORED
	
	if(is_user_alive(id))
	{
		if(owner != id)
		{
			fm_set_rendering(ent)
			kill_follow(ent)
			
			owner = id
			set_pev(ient, pev_velocity, Float:{0.0, 0.0, 0.0})

		}
	}
	else
	{
		static Float:vel[3]
		pev(ient, pev_velocity, vel)

		vel[0] *= 0.8
		vel[1] *= 0.8
		vel[2] *= 0.8
		//emit_sound(ient, CHAN_AUTO, snd, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		set_pev(ient, pev_velocity, vel)
	
	}
	
	return HAM_IGNORED
}

public ball_think(ient)
{
	static classname[32]
	pev(ient, pev_classname, classname, 31)
	
	if(!equal(classname, "ball"))
	return HAM_IGNORED
	
	if(!owner)
	{
		static Float:vel[3]
		pev(ient, pev_velocity, vel)
		if(vector_length(vel) < 1.0)
		{
			if(pev(ient, pev_renderfx) != kRenderFxNone)
			{
				fm_set_rendering(ient)
			}
		}
		if(pev(ient, pev_solid) != SOLID_BBOX)
		{
			set_pev(ent, pev_solid, SOLID_BBOX)
			set_pev(ent, pev_movetype, MOVETYPE_BOUNCE)
			engfunc(EngFunc_SetSize, ent,Float:{-7.0, -7.0, -0.0}, Float:{7.0, 7.0, 100.0})
		}
			
	}
	else
	{
		beam_follow(ient, 10, 4, 0, 150, 0)
		
	}
	
	set_pev(ient, pev_nextthink, get_gametime() + 1.0)
	return HAM_IGNORED
	
}

stock beam_follow(ient, life, w, r, g, b)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BEAMFOLLOW)
	write_short(ient)
	write_short(trail)
	write_byte(life) 
	write_byte(w) 
	write_byte(r)
	write_byte(g)
	write_byte(b)
	write_byte(200)
	message_end()
	
}

stock kill_follow(ient)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_KILLBEAM)
	write_short(ient)
	message_end()
			
}

stock fm_set_rendering(entity, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16)
{
	new Float:RenderColor[3]
	RenderColor[0] = float(r)
	RenderColor[1] = float(g)
	RenderColor[2] = float(b)

	set_pev(entity, pev_renderfx, fx)
	set_pev(entity, pev_rendercolor, RenderColor)
	set_pev(entity, pev_rendermode, render)
	set_pev(entity, pev_renderamt, float(amount))

	return 1
}

stock hud_msg(id, const message[], red, green, blue, Float:x, Float:y, effect, Float:fxtime, Float:holdtime, Float:fadein, Float:fadeout) 
{
	static color 
	color = clamp(blue, 0, 255 ) +( clamp(green, 0, 255 ) << 8) + (clamp(red, 0, 255 ) << 16) 
	message_begin(id? MSG_ONE_UNRELIABLE : MSG_BROADCAST, SVC_DIRECTOR, _, id) 
	write_byte(strlen(message) + 31) 
	write_byte(DRC_CMD_MESSAGE) 
	write_byte(effect) 
	write_long(color) 
	write_long(_:x) 
	write_long(_:y) 
	write_long(_:fadein) 
	write_long(_:fadeout) 
	write_long(_:holdtime) 
	write_long(_:fxtime) 
	write_string(message) 
	message_end() 
} 

	
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/