/*
 	v0.1 - [05.03.2012] First release
	v0.1a - [05.03.2012] Removed Fakemeta function
	v0.1b - [25.03.2012] Added Dead flag reset to - DEAD_DEAD
	v0.1c - [28.03.2012] Added Team info in - 'pev_team' (now indexed in TDM)
	v0.1d - [30.03.2012] Fixed spectator mode - team, after rejoin
	
	Plugin tested with Parabot 0.91 & jk_botti 1.42
	
	http://aghl.ru/forum/ - Russian Half-Life and Adrenaline Gamer Community
*/

//#define DEBUG

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define PLUGIN 	"hl_update_data_fix"
#define VERSION "0.1d"
#define AUTHOR 	"Turanga_Leela" 

#define Team_List_Max_Len	128
#define XTRA_OFS_PLAYER 	20 // 5 * 4
#define m_szTeamName		1532 // 383 * 4

#define None		0

new Trie:g_trie_handle

public plugin_cfg()
{
	g_trie_handle = TrieCreate()
	
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	if(get_cvar_num("mp_teamplay"))
	{
		RegisterHam(Ham_Spawn, "player", "Client_Spawn_Post", 1)
		
		new 
		
		team_list[Team_List_Max_Len],
		team[32],
		_char,
		w,
		team_index
		
		get_pcvar_string(get_cvar_pointer("mp_teamlist"), team_list, charsmax(team_list))
		trim(team_list)
		
		for(new f; f < sizeof team_list; f++)
		{
			switch(team_list[_char])
			{
				case ';':
				{
					team_index++
					TrieSetCell(g_trie_handle, team, team_index)
				
					_char++
					w = None
				
					for(new v; v < sizeof team; v++)
					{
						team[v] = None
					}
				
					continue
				}
				
				case EOS:
				{
					TrieSetCell(g_trie_handle, team, team_index + 1)
			
					break
				}
			}
			
			team[w] = team_list[_char]
			
			_char++
			w++
		}
		
		return
	}
	
	TrieDestroy(g_trie_handle)	
}

public Client_Spawn_Post(id)
{
	if(pev_valid(id))
	{
		new szTeamName[32]
		
		get_pdata_string(id, m_szTeamName, szTeamName, charsmax(szTeamName), None, XTRA_OFS_PLAYER)

		if(TrieKeyExists(g_trie_handle, szTeamName))
		{
			new i_team
			
			TrieGetCell(g_trie_handle, szTeamName, i_team)
	
			set_pev(id, pev_team, i_team)
#if defined DEBUG				
			server_print("Team = %d", i_team)
#endif
		}
	}
}

public client_disconnect(id)
{
	set_pev(id, pev_team, None)
	set_pev(id, pev_deadflag, DEAD_DEAD)
	set_pev(id, pev_flags, None)
}
