/*
	v0.1 - [20.09.2011] First release 
	v0.1a - [23.09.2011] Code optimizations, added macros options 
	v0.1b - [30.09.2011] Added new cvars
	v0.2 - [07.04.2012] 1)New code 2)Fixed hp/ap add - ignores high values 3)Removed cvars 4)Added animate models, thanks - "Koshak" :D 5)New sounds 6)On death if player has rune - it will be dropped
	v0.2a - [08.04.2012] 1)Fixed cs/csz && Event New Round 2)Fixed Rune double touch (when pick up) 3)Fixed rune remove on owner disconnect
	
	http://aghl.ru/forum/ - Russian Half-Life and Adrenaline Gamer Community
*/
	
#define Half_Life		// hl || cs/csz	
//#define zBot_on_server 	// enable this if you have zBot on server! (works on "cs/csz" ONLY!) *NEED`s* - "hamsandwich_zBot_FIX" - PLUGIN!
	
/* 
********************
* Availiable Runes *
********************	
*/	
	
#define _Quad_Damage
#define _Defence
#define _Regeneration
#define _Invisibility
	
/* 
*******
* End *
*******
*/	
	
/* 
******************
* Plugin Options *
******************	
*/
		
#define Rendering_Player		// enable player rendering ...if off - "Rendering_For_Invisible_Only" - will be ignored
#define Rendering_For_Invisible_Only	// only invisible rune will be rendered, else - all (depend from cvar)
	
#define Adrenaline_Points	100	// points value needs to get rune
#define Adrenaline_Add 		10	// points added for killing
#define Adrenaline_Sub 		5	// points removed from id adrenaline every - "Adrenaline_Sub_Timer" Seconds 

#define Animation_FrameRate	1.0	// Animation speed
#define Adrenaline_Multiple	0.85	// MUST BE > 0.0 ! adrenaline percent remaining after death (if it was)

#define QuadBonusDamage 	2.5	// bonus(multiple) damage received from <id> - "quad damage"
#define DefenceBlockPercent	0.1	// damage(multiple) for <id> - "defence"

#define Regeneration_Ceiling	100.0	// max points regenerates
#define Bonus_HP		5.0	// regen HP
#define Bonus_AP		2.0	// regen AP

#define Adrenaline_Sub_Timer	1.0	
#define Regeneration_Timer	1.0	

/* 
***************
* End Options *
***************
*/

#include <amxmodx>
#include <fakemeta_util>
#include <hamsandwich>
#include <engine>

#define PLUGIN 	"hl_adrenaline_upd"
#define VERSION "0.2a"
#define AUTHOR 	"Turanga_Leela"

#if defined _Quad_Damage
	#define _Q rune_Quad_Damage
#else
	#define _Q None
#endif

#if defined _Defence
	#define _D rune_Defence
#else 
	#define _D None
#endif

#if defined _Regeneration
	#define _R rune_Regeneration
#else 
	#define _R None
#endif

#if defined _Invisibility && defined Rendering_Player
	#define _I rune_Invisibility
#else 
	#define _I None
#endif

enum _:Block_Type(<<= 1)
{
	_on_Disconnect = 1,
	_on_Death,
	_on_NewRound,
	_on_AdrenalineEnd
}

enum _:Status_Visibility
{
	_Entity_Hide,
	_Entity_Show
}

enum _:_Status_Mode
{
	_Entity_Follow,
	_Entity_Static_Block,
	_Entity_Static_Free
}

enum _:_Colors
{
	_Red,
	_Green,
	_Blue
}
	
enum _:_Quake_Runes(<<= 1)
{
	rune_Quad_Damage = 1,
	rune_Defence,
	rune_Regeneration,
	rune_Invisibility
	
	/* Not supported	
	,
	rune_Haste,
	rune_Fly 
	
	*/
}

enum _:_Client_Data
{
	_data_Model_Follow,
	_data_Model_Static,
	_data_Adrenaline,
	_data_Adrenaline_Lost,
	_data_Rune,
	_data_Rune_Touched
}

enum _:_Plugin_Data
{
	_Max_Players,
	_client_bot,
	_client_alive,
	_Disconnect_Fix,
	_client_connected,
	_Total_Runes_Activated,
	_Hud
}

new 
g_client_data[32][_Client_Data],
g_plugin_data[_Plugin_Data],
HamHook:g_Ham_Switch
#if defined zBot_on_server && !defined Half_Life
,
HamHook:g_Ham_Switch_zBot
#endif

#define LINUX_OFFSET		5
#define CS_last_hit_group	75 
#define HL_last_hit_group	90 

#define Hud_Msg			g_plugin_data[_Hud]
#define Runes_On_Map		g_plugin_data[_Total_Runes_Activated]
#define MaxPlayers		g_plugin_data[_Max_Players]
#define None			0

#define Client_Data(%1,%2)	g_client_data[%1 - 1][%2]
	
#define bit_fix_add(%1)		g_plugin_data[_Disconnect_Fix] |= 1 << (%1 - 1)
#define bit_fix_sub(%1)		g_plugin_data[_Disconnect_Fix] &= ~(1 << (%1 - 1))
#define bit_fix(%1)		g_plugin_data[_Disconnect_Fix] & 1 << (%1 - 1)	

#define bit_alive_NOT(%1)	(1 << (%1 - 1) & ~g_plugin_data[_client_alive])
#define bit_alive_add(%1)	g_plugin_data[_client_alive] |= 1 << (%1 - 1)
#define bit_alive_sub(%1)	g_plugin_data[_client_alive] &= ~(1 << (%1 - 1))
#define bit_alive(%1)		g_plugin_data[_client_alive] & 1 << (%1 - 1)

#define bit_bot_NOT(%1)		(1 << (%1 - 1) & ~g_plugin_data[_client_bot]) 
#define bit_bot_add(%1)		g_plugin_data[_client_bot] |= 1 << (%1 - 1)
#define bit_bot_sub(%1)		g_plugin_data[_client_bot] &= ~(1 << (%1 - 1))
#define bit_bot(%1)		g_plugin_data[_client_bot] & 1 << (%1 - 1)
		
#define bit_connected_add(%1)	g_plugin_data[_client_connected] |= 1 << (%1 - 1)
#define bit_connected_sub(%1)	g_plugin_data[_client_connected] &= ~(1 << (%1 - 1))
#define bit_connected(%1)	g_plugin_data[_client_connected] & 1 << (%1 - 1)

new const Render_Colors[][] = 
{		
	// - QuadDamage
	{None, 0xff, 0xff},

	// - Defence
	{0xff, 0x80, None}, 
	
	// - Regeneration 
	{0xff, None, None}, 
		
	// - Invisibility
	{0xff, 0xff, 0xff}
	/*
	, 
	// - Haste
	{0, 255, 255}//,
		
	// - Fly
	{255, 0, 255} 
	*/
}

const Approved_Runes = (_Q | _D | _R | _I)

#define sound_Defence			"spk sound/q3/q3_defense_b"
#define sound_QuadDamage		"spk sound/q3/q3_quaddamage_b"
#define sound_Regeneration		"spk sound/q3/q3_regeneration_b"
#define sound_Invisibility		"spk sound/q3/q3_invisibility_b"

#define sound_Regeneration_Beep		"spk sound/q3/q3_regen_b"
#define sound_Beep			"spk sound/q3/q3_wearoff_b"
#define sound_Haste			"spk sound/q3/q3_haste_b"

#define sound_PickUp_Emit		"q3/q3_s_health_b.wav"
#define sound_PickUp			"spk sound/q3/q3_s_health_b"

public plugin_precache()
{
	new const quake_III_sounds[][] =
	{
		"q3/q3_defense_b.wav",
		"q3/q3_haste_b.wav",
		"q3/q3_invisibility_b.wav",
		"q3/q3_quaddamage_b.wav",
		"q3/q3_regen_b.wav",
		"q3/q3_regeneration_b.wav",
		"q3/q3_s_health_b.wav",
		"q3/q3_wearoff_b.wav"
	}
	
	for(new i; i < sizeof quake_III_sounds; i++)
	{
		precache_sound(quake_III_sounds[i])
	}
	
	new const Model[][] =
	{
		"models/q3/q3_id_b.mdl",
		"models/q3/q3_world_b.mdl"
	}
	
	for(new i; i < sizeof Model; i++)
	{
		precache_model(Model[i])
	}
}

#if defined zBot_on_server && !defined Half_Life
public zBot_entered_the_game(id)
{
	DisableHamForward(g_Ham_Switch_zBot = RegisterHamFromEntity(Ham_TakeDamage, id, "Client_Damaged_Pre", None))
}	

public zBot_change_data(id, zBot_alive, zBot_in_game)
{
	if(id > None && 1 << (id - 1) & zBot_alive)
	{
		Client_Spawned_Post(id)
	}
}
#endif

public client_connect(id)
{
	bit_connected_add(id)
	
	if(is_user_bot(id))
	{
		bit_bot_add(id)
	}
}

public client_disconnect(id)
{
	bit_connected_sub(id)
	bit_bot_sub(id)
	bit_alive_sub(id)
	
	Client_Data(id, _data_Adrenaline_Lost) = None
	Client_Data(id, _data_Rune_Touched) = None
	
/*	
	if(bit_bot_NOT(id))
	{
		client_cmd(id, "mp3 stop")
	}
*/
		
	Block_Rune(id, _on_Disconnect)
}

public Client_Spawned_Post(id)
{
	if(bit_connected(id))
	{
		bit_alive_add(id)
	}
}

Switch_Status(ent, Owner, Status_Mode, Visibility_Mode, Body = None)
{
	if(Change_Visibility(ent, Visibility_Mode) && Status_Mode)
	{
		enum
		{
			move_,
			solid_,
			all_
		}
			
		new const data[][all_] =
		{
			{MOVETYPE_FOLLOW, SOLID_NOT},
			{MOVETYPE_TOSS, SOLID_TRIGGER} // MOVETYPE_PUSHSTEP
		}
			
		set_pev(ent, pev_movetype, data[Status_Mode - 0x1][move_])
		set_pev(ent, pev_solid, data[Status_Mode - 0x1][solid_])
		
		new i
		
		switch(Status_Mode)
		{
			case _Entity_Static_Block:
			{
				i = Owner
			}
			
			case _Entity_Static_Free:
			{
				Rune_Rendering(ent, Render_Colors[Body][_Red], Render_Colors[Body][_Green], Render_Colors[Body][_Blue])
				
				i = None
				
				new Float:f[3]
			
				pev(Owner, pev_origin, f)
				set_pev(ent, pev_origin, f)
			
				f[0] = random_float(-255.0, 255.0)
				f[1] = random_float(-255.0, 255.0)
				f[2] = random_float(128.0, 255.0)
			
				set_pev(ent, pev_velocity, f)
			}	
		}
		
		set_pev(ent, pev_aiment, i)
	}
	
	/* return None */
}

public Client_Touch_Rune_Post(ent, id)
{	
	if(pev_valid(ent))
	{
		if(None < id <= MaxPlayers && bit_alive(id))
		{
			if(++Client_Data(id, _data_Rune_Touched) == 0x2)
			{
				Client_Data(id, _data_Rune_Touched) = None
				
				return
			}
			
			new owner
			
			if((owner = pev(ent, pev_owner)) == id)
			{
				bit_fix_sub(id)
			}
		
			Switch_Status(ent, owner, _Entity_Static_Block, _Entity_Hide)
			Client_Data(id, _data_Adrenaline) += Client_Data(owner, _data_Adrenaline_Lost)
	
			switch(Client_Data(id, _data_Rune))
			{
				case None:
				{
					Add_Rune(id, (pev(ent, pev_body) - 0x1))
				}
			
				default:
				{
					if(bit_bot_NOT(id) && Client_Data(owner, _data_Adrenaline_Lost))
					{
						client_print(id, print_chat, "<Adrenaline> += %d : [%d]", Client_Data(owner, _data_Adrenaline_Lost), Client_Data(id, _data_Adrenaline))	
					}	
				}
			}
		
			Client_Data(owner, _data_Adrenaline_Lost) = None
		
			emit_sound(id, CHAN_AUTO, sound_PickUp_Emit, VOL_NORM, ATTN_NORM, None, PITCH_NORM)
		}
	
		else if(!id || (id > MaxPlayers && pev_valid(id) && pev(id, pev_solid) & SOLID_BSP))
		{
			set_pev(ent, pev_angles, Float:{0.0, 0.0, 0.0})
		}
	}
}

public Remove_Adrenaline(id)
{
	if(/*bit_connected(id) &&*/ Client_Data(id, _data_Rune))
	{
		Client_Data(id, _data_Adrenaline) -= _:Adrenaline_Sub

		if(None < Client_Data(id, _data_Adrenaline))
		{
			if(bit_bot_NOT(id))
			{
				new Rune = Client_Data(id, _data_Rune) >> 0x1
				
				if(Client_Data(id, _data_Rune) & rune_Invisibility)
				{
					Rune--
				}
				
				static const sHud_Messages[][] =
				{
					"<Quad Damage> %= ",
					"<Defence> %= ",
					"<Regeneration> %= ",
					"<Invisibility> %= "
					
					/*
					,
					"<Haste> - ",
					"Fly"
					*/
				}
				
				if(Client_Data(id, _data_Adrenaline) <= _:Adrenaline_Sub * 0x5)
				{
					client_cmd(id, sound_Beep)
					//client_cmd(id, "mp3 play sound/q3/wearoff")	
				}
#if !defined Half_Life				
				set_hudmessage(Render_Colors[Rune][_Red], Render_Colors[Rune][_Green], Render_Colors[Rune][_Blue], -1.0, 0.85, 2, 1.0, 1.0, 0.0, 0.0, -1)
#else
				set_hudmessage(Render_Colors[Rune][_Red], Render_Colors[Rune][_Green], Render_Colors[Rune][_Blue], -1.0, 0.75, 2, 1.0, 2.0, 0.0, 0.0, -1) // -0.95, 0.825
#endif
				ShowSyncHudMsg(id, Hud_Msg, "%s%s%d%s", sHud_Messages[Rune /*Client_Data(id, _data_Rune) & rune_Invisibility ? ((Client_Data(id, _data_Rune) >> 0x1) - 0x1) : (Client_Data(id, _data_Rune) >> 0x1)*/], "[", (Client_Data(id, _data_Adrenaline) / _:Adrenaline_Sub), "]")
			}
		}
		
		else
		{
			Block_Rune(id, _on_AdrenalineEnd)
		
			return
		}

		set_task(Float:Adrenaline_Sub_Timer, "Remove_Adrenaline", id)
	}
}

public plugin_cfg()
{	
	Hud_Msg = CreateHudSyncObj()
	MaxPlayers = get_maxplayers()
	
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_event("DeathMsg", "On_Client_Death", "a")
#if !defined Half_Life
	register_logevent("On_New_Round", 2, "1=Round_Start")
#endif	
	RegisterHam(Ham_Spawn, "player", "Client_Spawned_Post", 1)
	DisableHamForward(g_Ham_Switch = RegisterHam(Ham_TakeDamage, "player", "Client_Damaged_Pre", None))
	
	new const Model[][] =
	{
		"models/q3/q3_id_b.mdl",
		"models/q3/q3_world_b.mdl"
	}
	
	new const ClassName[][] =
	{
		"q3_follow",
		"q3_static"
	}
	
	new const Float:Amount[] =
	{
		16.0,
		32.0
	}
	
	new 
	
	_cache,
	ent
	
	for(new i; i < sizeof ClassName; i++)
	{
		for(new id = 1; id <= MaxPlayers; id++)
		{
			if((_cache || (_cache = engfunc(EngFunc_AllocString, "info_target"))) && pev_valid((ent = engfunc(EngFunc_CreateNamedEntity, _cache))))
			{
				engfunc(EngFunc_SetModel, ent, Model[i])
				
				set_pev(ent, pev_classname, ClassName[i])
				set_pev(ent, pev_owner, id)
				set_pev(ent, pev_solid, SOLID_NOT)
				set_pev(ent, pev_body, None)
				set_pev(ent, pev_aiment, id)
				set_pev(ent, pev_movetype, MOVETYPE_FOLLOW)
				set_pev(ent, pev_framerate, Float:Animation_FrameRate)
				
				set_pev(ent, pev_renderfx, kRenderFxGlowShell)
				set_pev(ent, pev_rendermode, kRenderNormal)
				set_pev(ent, pev_renderamt, Amount[i])
				
				if(i)
				{
					set_pev(ent, pev_mins, Float:{-2.5, -2.5, -2.5})
					set_pev(ent, pev_maxs, Float:{2.5, 2.5, 2.5})
					
					engfunc(EngFunc_SetSize, ent, Float:{-2.5, -2.5, -2.5}, Float:{2.5, 2.5, 2.5})
				}
				
				dllfunc(DLLFunc_Spawn, ent)
			
				Client_Data(id, i) = ent
				Change_Visibility(ent, _Entity_Hide)
			}
		}
#if defined Half_Life		
		register_touch("q3_static", "*", "Client_Touch_Rune_Post")
#else
		register_touch("q3_static", "*", "Client_Touch_Rune_Post")
#endif
	}
}

#if !defined Half_Life
public On_New_Round()
{
	for(new id = 1; id <= MaxPlayers; id++)
	{
		//if(bit_connected(id))
		//{
			Block_Rune(id, _on_NewRound)
			//bit_fix_sub(id)
		//}
	}
}
#endif

public Client_Damaged_Pre(id, idinflictor, idattacker, Float:damage, damagebits)
{
	static Float:damage_multiple
	
	if((damage_multiple = damage) >= 1.0)
	{
		if((None < idattacker <= MaxPlayers) && Client_Data(idattacker, _data_Rune) & rune_Quad_Damage)
		{
			damage_multiple *= Float:QuadBonusDamage
		}
		
		if(Client_Data(id, _data_Rune) & rune_Defence)
		{
			damage_multiple *= Float:DefenceBlockPercent
		}
		
		SetHamParamFloat(0x4, damage_multiple)
		
		return HAM_HANDLED
	}
	
	return HAM_IGNORED
}

bool:Change_Visibility(ent, mode = None)
{
	if(pev_valid(ent))
	{
		new effects = pev(ent, pev_effects)
		
		switch(mode)
		{
			case _Entity_Hide:
			{
				effects |= EF_NODRAW
			}
			
			default:
			{
				effects &= ~EF_NODRAW
			}
		}
		
		set_pev(ent, pev_effects, effects)
		
		return true
	}
	
	set_fail_state("Error: Wrong entity index - <hl_adrenaline - disabled>")
	
	return false
}

Block_Rune(id, mode)
{	
	new bool:ignore = false
	
	if((mode & (_on_Disconnect | _on_AdrenalineEnd)) || Client_Data(id, _data_Adrenaline) < None)
	{
		Client_Data(id, _data_Adrenaline) = None
	}	
#if defined Half_Life		
	if(Client_Data(id, _data_Rune) || ((ignore = (mode & _on_Disconnect && bit_fix(id)))))
#else
	if(Client_Data(id, _data_Rune) || ((ignore = (mode & (_on_NewRound | _on_Disconnect) && bit_fix(id)))))
#endif
	{
		new Body = Client_Data(id, _data_Rune) & rune_Invisibility ? (Client_Data(id, _data_Rune) >> 0x1) : ((Client_Data(id, _data_Rune) >> 0x1) + 0x1)
		
		switch(mode)
		{
			case _on_Death:
			{				
				bit_fix_add(id)
				
				Switch_Status(Client_Data(id, _data_Model_Static), id, _Entity_Static_Free, _Entity_Show, Body - 0x1)
				Switch_Status(Client_Data(id, _data_Model_Follow), id, _Entity_Follow, _Entity_Hide)
				
				set_pev(Client_Data(id, _data_Model_Follow), pev_body, None)
				set_pev(Client_Data(id, _data_Model_Static), pev_body, Body)
			}		
#if !defined Half_Life 		
			case _on_Disconnect, _on_NewRound:
#else 
			case _on_Disconnect:
#endif
			{
				Switch_Status(Client_Data(id, _data_Model_Static), id, _Entity_Static_Block, _Entity_Hide)
				Switch_Status(Client_Data(id, _data_Model_Follow), id, _Entity_Follow, _Entity_Hide)
				
				set_pev(Client_Data(id, _data_Model_Follow), pev_body, None)
				set_pev(Client_Data(id, _data_Model_Static), pev_body, None)	
					
				if(ignore)
				{
					bit_fix_sub(id)
					
					return
				}				
			}
			
			case _on_AdrenalineEnd:
			{
				Switch_Status(Client_Data(id, _data_Model_Follow), id, _Entity_Follow, _Entity_Hide)
				set_pev(Client_Data(id, _data_Model_Follow), pev_body, None)
			}
		}
#if defined Rendering_Player		
#if defined Rendering_For_Invisible_Only
		if(Client_Data(id, _data_Rune) & rune_Invisibility)
		{
			fm_set_rendering(id, kRenderFxNone, None, None, None, kRenderNormal, None)
		}
#else
		fm_set_rendering(id, kRenderFxNone, None, None, None, kRenderNormal, None)
#endif
#endif
		if(Client_Data(id, _data_Rune) & (rune_Defence | rune_Quad_Damage))
		{
			Runes_On_Map--
	
			if(!Runes_On_Map)
			{
				DisableHamForward(g_Ham_Switch)
#if defined zBot_on_server && !defined Half_Life
				DisableHamForward(g_Ham_Switch_zBot)
#endif
			}
		}
		
		Client_Data(id, _data_Rune) = None
	}
}

public On_Client_Death()
{
	new 
	
	killer = read_data(1),
	victim = read_data(2),
	
	lost = Client_Data(victim, _data_Adrenaline)
	Client_Data(victim, _data_Adrenaline_Lost) += lost - (Client_Data(victim, _data_Adrenaline) = floatround(Client_Data(victim, _data_Adrenaline) * Float:Adrenaline_Multiple))
	
	Block_Rune(victim, _on_Death)
	bit_alive_sub(victim)
	
	if(None < killer <= MaxPlayers && killer ^ victim && bit_connected(killer))
	{
		new 
		
		Float:adrenaline_bonus,
		Difference
		
#if !defined Half_Life				
		switch(get_pdata_int(victim, CS_last_hit_group, LINUX_OFFSET))
#else
		switch(get_pdata_int(victim, HL_last_hit_group, LINUX_OFFSET))
#endif	
		{
			case HIT_HEAD:			adrenaline_bonus = 2.0
			case HIT_CHEST:			adrenaline_bonus = 1.85
			case HIT_STOMACH:		adrenaline_bonus = 1.6
			case HIT_LEFTARM, HIT_RIGHTARM:	adrenaline_bonus = 1.45
			case HIT_LEFTLEG, HIT_RIGHTLEG:	adrenaline_bonus = 1.3
		
			default:			adrenaline_bonus = 1.15
		}
		
		Client_Data(killer, _data_Adrenaline) += (Difference = floatround(_:Adrenaline_Add * random_float(1.0, adrenaline_bonus)))
	
		if(bit_bot_NOT(killer))
		{
			client_print(killer, print_chat, "<Adrenaline> += %d : [%d]", Difference, Client_Data(killer, _data_Adrenaline))	
		}
		
		if(Client_Data(killer, _data_Adrenaline) >= _:Adrenaline_Points && !Client_Data(killer, _data_Rune))
		{
			//if(pev_valid(Client_Data(killer, _data_Model_Static)) && pev(Client_Data(killer, _data_Model_Static), pev_body))
			//{
			
			Switch_Status(Client_Data(killer, _data_Model_Static), killer, _Entity_Static_Block, _Entity_Hide)
			
			//}
			
			bit_fix_sub(killer)
			
			new 
			
			quake_rune,
			random_rune[0x4]
		
			for(new index; index < sizeof random_rune; index++)
			{
				if(1 << index & Approved_Runes)
				{
					random_rune[quake_rune] = index
					quake_rune++	
				}	
			}
			
			if(quake_rune)
			{
				Add_Rune(killer, random_rune[random(quake_rune)])
			}
		}	
	}
	
	// return None
}

Add_Rune(id, q3_rune)
{	
#if defined Rendering_Player
	enum
	{
		__kRenderFx,
		__kRender
	}
#endif
	new const Hud_Messages[][] =
	{
		"Quad Damage",
		"Defence",
		"Regeneration",
		"Invisibility"
	/*
		,
		"Haste",
		//"Fly"
	*/
	}
	
	new const Sounds[][] =
	{		
		sound_QuadDamage,		
		sound_Defence,		
		sound_Regeneration,		
		sound_Invisibility
	/*	
		,
		"mp3 play sound/q3/haste",
		//fly
	*/
	}
#if defined Rendering_Player	
	new const Rendering[][] =
	{
		{kRenderFxGlowShell, kRenderTransColor},
		{kRenderFxGlowShell, kRenderTransColor},
		{kRenderFxGlowShell, kRenderTransColor},
		{kRenderFxNone, kRenderTransAlpha}
	/*	
		,
		{kRenderFxGlowShell, kRenderGlow},
		//{} - fly
	*/
	}
#endif
	if(bit_bot_NOT(id))
	{
		client_cmd(id, Sounds[q3_rune])
		
		set_hudmessage(Render_Colors[q3_rune][_Red], Render_Colors[q3_rune][_Green], Render_Colors[q3_rune][_Blue], -1.0, 0.60, 2, 1.0, 5.0, 0.75, 2.5, -1)		
		show_hudmessage(id, "%s", Hud_Messages[q3_rune])	
	}
	
	if((Client_Data(id, _data_Rune) = 0x1 << q3_rune) & rune_Regeneration)
	{
		Regeneration_Enable(id)
	}
	
	else if(Client_Data(id, _data_Rune) & (rune_Quad_Damage | rune_Defence))
	{
		Runes_On_Map++
	
		if(Runes_On_Map == 0x1)
		{
			EnableHamForward(g_Ham_Switch)
#if defined zBot_on_server && !defined Half_Life
			EnableHamForward(g_Ham_Switch_zBot)
#endif
		}
	}
	
#if defined Rendering_Player	
#if defined Rendering_For_Invisible_Only
	if(Client_Data(id, _data_Rune) & rune_Invisibility)
	{
		fm_set_rendering(id, Rendering[q3_rune][__kRenderFx], Render_Colors[q3_rune][_Red], Render_Colors[q3_rune][_Green], Render_Colors[q3_rune][_Blue], Rendering[q3_rune][__kRender], 0x20)
	}
#else
	fm_set_rendering(id, Rendering[q3_rune][__kRenderFx], Render_Colors[q3_rune][_Red], Render_Colors[q3_rune][_Green], Render_Colors[q3_rune][_Blue], Rendering[q3_rune][__kRender], 0x20)
#endif	
#endif
	Switch_Status(Client_Data(id, _data_Model_Follow), id, _Entity_Follow, _Entity_Show)
	Rune_Rendering(Client_Data(id, _data_Model_Follow), Render_Colors[q3_rune][_Red], Render_Colors[q3_rune][_Green], Render_Colors[q3_rune][_Blue])
	
	set_pev(Client_Data(id, _data_Model_Follow), pev_body, q3_rune + 0x1)
	
	Remove_Adrenaline(id)
}

Rune_Rendering(ent, r, g, b)
{
	if(pev_valid(ent))
	{	
		new Float:Render[3]
	
		Render[_Red] = float(r)
		Render[_Green] = float(g)
		Render[_Blue] = float(b)
	
		set_pev(ent, pev_rendercolor, Render)
	}
}

Set_Points(id, mode)
{
	static const Pev_Const[] =
	{
		pev_health,
		pev_armorvalue
	}
	
	static const Float:Bonus[] =
	{
		Float:Bonus_HP,
		Float:Bonus_AP
	}
	
	static 
	
	Float:value,
	Float:regen
	
	pev(id, Pev_Const[mode], value)
	
	if(value >= Float:Regeneration_Ceiling || bit_alive_NOT(id))
	{
		return
	}
	
	else
	{
		if((regen = (Float:Regeneration_Ceiling - value)) < Bonus[mode])
		{
			value += regen
		}
		
		else
		{
			value += Bonus[mode]
		}
	}
	
	set_pev(id, Pev_Const[mode], value)	
}

public Regeneration_Enable(id)
{
	enum
	{
		_Regenerate_HP,
		_Regenerate_AP
	}
	
	if(Client_Data(id, _data_Rune) & rune_Regeneration)
	{
		if(bit_bot_NOT(id))
		{
			client_cmd(id, sound_Regeneration_Beep)
		}
		
		Set_Points(id, _Regenerate_HP)
		Set_Points(id, _Regenerate_AP)
	
		set_task(Float:Regeneration_Timer, "Regeneration_Enable", id)
	}
}