/*
 	v0.1 - [04.01.2012] First release
	v0.1a - [28.01.2012] Small Optimizations + little fix
	
	http://aghl.ru/forum/ - Russian Half-Life and Adrenaline Gamer Community
*/

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <cstrike>

#define PLUGIN 	"hamsandwich_zBot_FIX"
#define VERSION "0.1a"
#define AUTHOR 	"Turanga_Leela"

#define BIT_SUM(%1)	1 << (%1 - 1)
#define FLAG_EXISTS	0
#define CHECK_zBot	0

enum _:GLOBAL_PLUGIN_FLAGS(<<= 1)
{
	ONCE = 1,
	zBot_ENABLE,
	RESET
}

enum _:PLUGIN_CONFIG
{
	zBot_CHANGE_DATA,
	zBot_CONNECTED
}

enum _:PLUGIN_DATA
{
	zBot_ALIVE,
	zBot_IN_GAME,
	PLUGIN_FLAGS,
	zBot_ENTERED_THE_GAME,
	RETURN,
	zBot_DATA,
	zBot_FIRST
}

new g_data[PLUGIN_DATA]

public zBot_check(id)
{
	if(g_data[zBot_IN_GAME] & BIT_SUM(id))
	{
		RegisterHamFromEntity(Ham_Spawn, id, "zBot_spawn_post", 1)
	
		change_zBot_data(zBot_CONNECTED, id)
		cs_user_spawn(id)	
	}
}

public zBot_spawn_post(id)
{
	switch(zBot_ENABLE & ~g_data[PLUGIN_FLAGS])
	{
		case FLAG_EXISTS:
		{
			g_data[PLUGIN_FLAGS] ^= zBot_ENABLE
			
			switch(BIT_SUM(id) & ~g_data[zBot_FIRST])
			{
				case CHECK_zBot:
				{
					if(g_data[PLUGIN_FLAGS] & RESET)
					{
						g_data[PLUGIN_FLAGS] ^= RESET
						
						return
					}
					
					g_data[zBot_ALIVE] |= BIT_SUM(id)
				}
				
				default:	return
			}
		}
		
		default:
		{
			g_data[zBot_ALIVE] |= BIT_SUM(id)
		}
	}
	
	change_zBot_data(zBot_CHANGE_DATA, id)
}

change_zBot_data(mode, index)
{
	switch(mode)
	{
		case zBot_CHANGE_DATA: 
		{
			ExecuteForward(g_data[zBot_DATA], g_data[RETURN], index, g_data[zBot_ALIVE], g_data[zBot_IN_GAME])
		}
		
		case zBot_CONNECTED: 
		{
			ExecuteForward(g_data[zBot_ENTERED_THE_GAME], g_data[RETURN], index)	
		}
	}
}

public zBot_put_in_server(NickName[])
{
	new
	
	status[32],
	zBot = get_orig_retval()

	get_user_authid(zBot, status, charsmax(status))
	
	if(equal(status, "BOT", 3))
	{
		g_data[zBot_IN_GAME] |= BIT_SUM(zBot)
		g_data[PLUGIN_FLAGS] |= zBot_ENABLE
	
		if(g_data[PLUGIN_FLAGS] & ONCE)
		{
			g_data[PLUGIN_FLAGS] ^= ONCE
			g_data[zBot_FIRST] |= BIT_SUM(zBot)
			
			g_data[zBot_DATA] = CreateMultiForward("zBot_change_data", ET_IGNORE, FP_CELL, FP_CELL, FP_CELL)
			g_data[zBot_ENTERED_THE_GAME] = CreateMultiForward("zBot_entered_the_game", ET_IGNORE, FP_CELL)
					
			set_task(0.5, "zBot_check", zBot)	
		}
		
		change_zBot_data(zBot_CHANGE_DATA, zBot)	
	}
}

public plugin_init()
{
	g_data[PLUGIN_FLAGS] |= ONCE
	
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_forward(FM_CreateFakeClient, "zBot_put_in_server", 1)
	register_event("DeathMsg", "zBot_death", "a")	
}

public zBot_death()
{
	new id = read_data(2)
	
	g_data[zBot_ALIVE] &= ~(BIT_SUM(id))
	
	if(g_data[zBot_IN_GAME] & BIT_SUM(id))
	{
		change_zBot_data(zBot_CHANGE_DATA, -id)
	}
}

public client_disconnect(id)
{
	if(g_data[zBot_IN_GAME] & BIT_SUM(id))
	{
		g_data[zBot_IN_GAME] ^= BIT_SUM(id)
		g_data[zBot_ALIVE] &= ~(BIT_SUM(id))
		
		if(BIT_SUM(id) & g_data[zBot_FIRST])
		{
			g_data[PLUGIN_FLAGS] |= RESET
		}
		
		change_zBot_data(zBot_CHANGE_DATA, -id)
	}
}
	
